/****************************************************
 *                                                  *
 * This is the main header file for the C Version   *
 * of the OptQuest Engine                           *
 *                                                  *
 * Copyright  2002 OptTek Systems, Inc             *
 *                                                  *
 ****************************************************/

/* Constants */
#define OCLON		   1
#define OCLOFF		   0
#define OCLLE          0
#define OCLEQ          1
#define OCLGE          2

/* LP Return Codes */
#define LPOPTIMAL				0	// Optimal Solution Found
#define LPMILP_FAIL				1	// Failure in the LP
#define LPINFEASIBLE			2	// No feasible solution
#define LPUNBOUNDED				3	// Unbounded Optimal
#define LPSTOPPED				4	// LP was stopped by callback
/* LP Return Codes when Maximum Number of Pivots was exceeded */
#define LPMAXOPTIMAL		 	10	
#define LPMAXMILP_FAIL   		11
#define LPMAXPIVINFEASIBLE  	12
#define LPMAXPIVUNBOUNDED   	13

/* Error Codes */
#define OCLErr1100  -1100   /* AutoStop termination														*/
#define OCLErr1200  -1200	/* Constraint index is out of range											*/
#define OCLErr1201  -1201	/* Constraints are infeasible												*/
#define OCLErr1400  -1400	/* Error while generating solutions											*/
#define OCLErr1500  -1500	/* Failed to select a value													*/
#define OCLErr1501  -1501	/* Failure in random number generator										*/
#define OCLErr1502  -1502	/* Failure mapping infeasible solution										*/
#define OCLErr1503  -1503	/* File could not be opened													*/
#define OCLErr1504  -1504	/* Function argument should be either BEST or ALL							*/
#define OCLErr2200  -2200	/* Memory allocation problem												*/
#define OCLErr2201  -2201	/* Maximum number of problem setups has been exceeded						*/
#define OCLErr2300  -2300	/* Number of requirements should be greater than or equal to zero			*/
#define OCLErr2301  -2301	/* Number of variables should be greater than zero							*/
#define OCLErr2400  -2400   /* OCLPutSolution must be called before calling OCLGetSolution again		*/
#define OCLErr2401  -2401	/* Optimization problem should be MAX or MIN								*/
#define OCLErr2410  -2410	/* OptQuest cannot find any more feasible solutions in the time available.  */
							/* The current best solution may not be optimal.  							*/
#define OCLErr2420  -2420	/* OptQuest cannot find any feasible solutions in the time available		*/
#define OCLErr2500  -2500	/* Parameter value is out of range											*/
#define OCLErr2501  -2501	/* New (different) solutions cannot be generated							*/
#define OCLErr2502  -2502   /* Problem identifier is out of range										*/
#define OCLErr2503  -2503   /* Problem identifier is not valid											*/
#define OCLErr2700  -2700	/* Requirement index is out of range										*/
#define OCLErr2800  -2800   /* Solution cannot be rejected												*/
#define OCLErr2801  -2801	/* Step value is larger than variable range									*/
#define OCLErr2802  -2802	/* Suggested value is out of bounds											*/
#define OCLErr2803  -2803   /* Step value must be strictly greater than zero							*/
#define OCLErr3000  -3000	/* Upper bound is smaller than lower bound									*/
#define OCLErr3001  -3001   /* Maximum number of values is limited to 100 in design variables			*/
#define OCLErr3100  -3100	/* Variable index is out of range											*/
#define OCLErr3101  -3101   /* Variable must be continuous (CON), integer (DIS) or categorical (DESIGN)	*/
#define OCLErr4000  -4000   /* OCLInitPop must be called before calling OCLSugSolution					*/
#define OCLErr4100  -4100   /* All variables must be integer											*/
#define OCLErr5000  -5000   /* Wrong license number														*/
#define OCLErr5001  -5001   /* Number of variables, req., cons., or iterations exceeds demo limits		*/
#define OCLErr5002  -5002   /* Optimal solution found													*/
#define OCLErr5003  -5003   /* License has expired  													*/
#define OCLErr5004  -5004   /* Function not available until all pop-solutions have been evaluate		*/
#define OCLErr5005  -5005   /* Function is not available												*/
#define OCLErr5006  -5006   /* Error while combining permutations										*/
#define OCLErr5007  -5007   /* Failure to select a type of strategy										*/
#define OCLErr5008  -5008   /* OptQuest Stopped															*/

#ifdef BUILD_OCL_DLL
#define HEAD_DLL __declspec(dllexport)
#else
#define HEAD_DLL
#endif

#ifdef WIN32
#define STDCALL	__stdcall
#else
#define STDCALL
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* General */
HEAD_DLL long STDCALL OCLSetup(long nvar,long nperm,long ncons,long req,char *direc,long license);
HEAD_DLL long STDCALL OCLGoodBye(long nprob);
HEAD_DLL long STDCALL OCLInitPop(long nprob);
HEAD_DLL long STDCALL OCLRestart(long nprob);
HEAD_DLL long STDCALL OCLCallback(long nprob, void *callback);
HEAD_DLL long STDCALL OCLSetDataBaseSize(long nprob,long value);
HEAD_DLL char *STDCALL OCLGetErrorString(long OCLErr);
HEAD_DLL char *STDCALL OCLGetVersion();

/* Variables, Requeriments and Constraints */
HEAD_DLL long STDCALL OCLDefineVar(long nprob,long var,double low,double sug,double high,char *type,double step);
HEAD_DLL long STDCALL OCLDefineReq(long nprob,long req,double low,double high);
HEAD_DLL long STDCALL OCLDefineObj(long nprob,long var,double value);
HEAD_DLL long STDCALL OCLConsCoeff(long nprob,long cons,long var,double value);
HEAD_DLL long STDCALL OCLConsRhs(long nprob,long cons,double value);
HEAD_DLL long STDCALL OCLConsType(long nprob,long cons,long type);

/* Solutions */
HEAD_DLL long STDCALL OCLGetSolution(long nprob,double *sol);
HEAD_DLL long STDCALL OCLSugSolution(long nprob,double *sol);
HEAD_DLL long STDCALL OCLPutSolution(long nprob,long nsol,double *ObjVal,double *sol);
HEAD_DLL long STDCALL OCLGetBest(long nprob,double *sol,double *ObjVal);
HEAD_DLL long STDCALL OCLSetFileSolutions(long nprob,char *name,char *mode);
HEAD_DLL long STDCALL OCLSugPopSolution(long nprob,double *sol);
HEAD_DLL long STDCALL OCLGetPopSolution(long nprob, long nsol,double *ObjVal,double *sol);
HEAD_DLL long STDCALL OCLPutPopSolution(long nprob, long nsol,double *ObjVal,double *sol);
HEAD_DLL long STDCALL OCLGenerateAllSolutions(long nprob);
HEAD_DLL long STDCALL OCLGetStoredSolution(long nprob, long nsol, double *sol, double *ObjVal);
HEAD_DLL long STDCALL OCLGetPopStats(long nprob, char *type, long i, double *stat);
HEAD_DLL long STDCALL OCLSolveLP(long nprob, double *obj, double *sol);

/* Parameters Settings */
HEAD_DLL long STDCALL OCLSetSearchStrategies(long nprob,char *type,double value);
HEAD_DLL long STDCALL OCLSetPopSize(long nprob,long value);
HEAD_DLL long STDCALL OCLSetSolutions(long nprob,long value);
HEAD_DLL long STDCALL OCLSetCheckDup(long nprob,long value);
HEAD_DLL long STDCALL OCLSetRandomSeed(long nprob,long value);
HEAD_DLL long STDCALL OCLSetObjPrecision(long nprob,double value);
HEAD_DLL long STDCALL OCLSetVarPrecision(long nprob,double value);
HEAD_DLL long STDCALL OCLSetIPPrecision(long nprob,double value);
HEAD_DLL long STDCALL OCLSetTaguchi(long nprob,long value);
HEAD_DLL long STDCALL OCLSetNull(long nprob,long value);
HEAD_DLL long STDCALL OCLGetNull(long nprob);
HEAD_DLL long STDCALL OCLSetAutoStop(long nprob,long option);

/* Neural Net */
HEAD_DLL long STDCALL OCLSetNNFilter(long nprob, long value, long level);
HEAD_DLL long STDCALL OCLNNSetup(long nin,long nhidden,long ntrain);
HEAD_DLL long STDCALL OCLNNCallback(long nin,void *cback);
HEAD_DLL long STDCALL OCLNNTrainData(long nnet,double *data,double value);
HEAD_DLL long STDCALL OCLNNTrain(long nnet,double *terror);
HEAD_DLL long STDCALL OCLNNActivation(long nnet,long option);
HEAD_DLL long STDCALL OCLNNSearchLevel(long nnet,long option);
HEAD_DLL long STDCALL OCLNNPrediction(long nnet,double *input,double *outp);
HEAD_DLL long STDCALL OCLNNGoodBye(long nnet);

#ifdef __cplusplus
}
#endif
